<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class Login extends Model
{
    public $username;
    public $password;

    private $_user = false;


   
    public function rules()
    {
        return [
            
            [['username', 'password'], 'required', 'message' => 'Необходимо заполнить это поле'],
           
           
            ['password', 'validatePassword'],
        ];
    }
    
    
    public function attributeLabels()
	 {
		 
		 return 
		 ['username' => 'Логин',
		  'password' => 'Пароль',
		 ];
		 
	 }
 
 
    public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();

          
            if (!$user || !Yii::$app->getSecurity()->validatePassword($this->password, $user->password)) {
                $this->addError($attribute, 'Неверный логин или пароль.');
            }
                
        }
    }

  
  
    public function getUser()
    {
        if ($this->_user === false) {
            $this->_user = User::findOne(['username' => $this->username]);
        }

        return $this->_user;
    }
	
	  public function login()
    {
        if ($this->validate()) {
            return Yii::$app->user->login($this->getUser(), 3600*24*30);
        }
        return false;
    }
	
	
}
